/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.functions;

import static java.util.Collections.singletonList;
import static org.mule.runtime.api.metadata.DataType.STRING;

import java.util.List;
import java.util.Optional;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.core.api.config.MuleManifest;

/**
 * Base class to implement a Mule Version comparison {@link ExpressionFunction}
 * 
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public abstract class AbstractMuleVersionFunction implements ExpressionFunction {

  @Override
  public Object call(Object[] parameters, BindingContext bindingContext) {
    MuleVersion muleVersion = new MuleVersion((String) parameters[0]);
    MuleVersion currentMuleVersion = new MuleVersion(getCurrentMuleVersion());
    return compare(muleVersion, currentMuleVersion);
  }

  @Override
  public Optional<DataType> returnType() {
    return Optional.of(DataType.BOOLEAN);
  }

  @Override
  public List<FunctionParameter> parameters() {
    return singletonList(new FunctionParameter("version", STRING));
  }

  /**
   * Base method to compare two mule versions
   * 
   * @param muleVersion Version sent as argument
   * @param currentMuleVersion Current Mule Version of the Mule Context
   * @return true if the comparison is successful, false if not
   */
  protected abstract boolean compare(MuleVersion muleVersion, MuleVersion currentMuleVersion);

  private String getCurrentMuleVersion() {
    return MuleManifest.getProductVersion();
  }
}
