/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import junit.framework.Assert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.builders.SuiteBuilder;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class SuiteBuilderTest {
    private static final String SUITE_PATH = "suitePath";
    private static final String SUITE_PARAMETERIZATION = "param1";
    private SuiteBuilder builder;
    private MunitModule munitModuleMock;
    private TestComponentLocator componentLocatorMock;
    private TestFlow testFlowMock;

    @Before
    public void setUp() {
        this.munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        this.componentLocatorMock = (TestComponentLocator)Mockito.mock(TestComponentLocator.class);
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)this.componentLocatorMock.lookupMunitModule()).thenReturn(Optional.of(this.munitModuleMock));
        Mockito.when((Object)this.componentLocatorMock.lookupBeforeSuite()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupAfterSuite()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupBeforeTest()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupAfterTest()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupTests()).thenReturn(Collections.singletonList(this.testFlowMock));
        DefaultComponentLocation.DefaultLocationPart part = (DefaultComponentLocation.DefaultLocationPart)Mockito.mock(DefaultComponentLocation.DefaultLocationPart.class);
        Mockito.when((Object)part.getFileName()).thenReturn(Optional.of(SUITE_PATH));
        this.builder = new SuiteBuilder(SUITE_PATH, SUITE_PARAMETERIZATION, this.componentLocatorMock);
    }

    @Test(expected=NullPointerException.class)
    public void createBuilderNullComponentLocatorFail() {
        new SuiteBuilder(SUITE_PATH, SUITE_PARAMETERIZATION, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createBuilderNullSuitePathFail() {
        new SuiteBuilder(null, SUITE_PARAMETERIZATION, this.componentLocatorMock);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createBuilderEmptySuitePathFail() {
        new SuiteBuilder("", SUITE_PARAMETERIZATION, this.componentLocatorMock);
    }

    @Test
    public void createTestMustNotBeNull() {
        Assert.assertNotNull((Object)this.builder.test(null, null, null, this.munitModuleMock));
    }

    @Test(expected=IllegalStateException.class)
    public void illegalArgumentIfMunitModuleNotPresent() {
        Mockito.when((Object)this.componentLocatorMock.lookupMunitModule()).thenReturn(Optional.empty());
        this.builder.build();
    }

    @Test
    public void allScopesMustBeRetrieved() {
        this.builder.build();
        this.verifyLookups();
    }

    @Test
    public void testBuildBlankTestToRunName() {
        this.builder.withTestNames(Collections.emptyList());
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsIsIgnored() {
        Mockito.when((Object)this.testFlowMock.isIgnored()).thenReturn((Object)true);
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsNameMatchesShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        this.builder.withTestNames(Arrays.asList("test_name"));
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsNameDoesntMatchShouldIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        this.builder.withTestNames(Arrays.asList("not_matching_test_name"));
        this.assertNumberOfTests(this.builder.build(), 0);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsDoesntMatchTagsShouldIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton("otherTag"));
        this.assertNumberOfTests(this.builder.build(), 0);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsMatchesSameTagShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton("oneTag"));
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    private void assertNumberOfTests(Suite suite, int numberOfTests) {
        MatcherAssert.assertThat((Object)suite.getNumberOfTests(), (Matcher)CoreMatchers.equalTo((Object)numberOfTests));
    }

    private void verifyLookups() {
        ((TestComponentLocator)Mockito.verify((Object)this.componentLocatorMock)).lookupMunitModule();
        ((TestComponentLocator)Mockito.verify((Object)this.componentLocatorMock)).lookupBeforeSuite();
        ((TestComponentLocator)Mockito.verify((Object)this.componentLocatorMock)).lookupAfterSuite();
        ((TestComponentLocator)Mockito.verify((Object)this.componentLocatorMock)).lookupBeforeTest();
        ((TestComponentLocator)Mockito.verify((Object)this.componentLocatorMock)).lookupAfterTest();
        ((TestComponentLocator)Mockito.verify((Object)this.componentLocatorMock)).lookupTests();
    }
}

