/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.model;

import org.mule.runtime.api.message.Error;

import static java.lang.String.format;

/**
 * <p>
 * Execution exception with {@link org.mule.runtime.api.message.ErrorType}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class TestExecutionException extends Exception {

  public static final String ERROR_MESSAGE_TEMPLATE = "Error [%s] while running test '%s':";

  public TestExecutionException(Throwable throwable, Error error, String testName) {
    super(generateMessage(error, testName), throwable);
  }

  private static String generateMessage(Error error, String testName) {
    String errorMessage = error.getErrorType() != null ? error.getErrorType().toString() : error.getCause().getClass().toString();
    return format(ERROR_MESSAGE_TEMPLATE, errorMessage, testName) + error.getCause().getMessage();
  }

}
