/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.mule.munit.common.api.event.EventBuilder;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.model.SuiteResult;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.remote.api.notifiers.DummySuiteRunEventListener;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Suite {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String path;
    private String parameterization;
    private BeforeSuite beforeSuiteFlow;
    private List<Test> tests;
    private AfterSuite afterSuiteFlow;
    private SuiteRunEventListener suiteRunEventListener;

    public Suite(String path) {
        this(path, "");
    }

    public Suite(String path, String parameterization) {
        this.path = path;
        this.parameterization = parameterization;
        this.tests = new ArrayList<Test>();
        this.suiteRunEventListener = new DummySuiteRunEventListener();
    }

    public void setSuiteRunEventListener(SuiteRunEventListener suiteRunEventListener) {
        Preconditions.checkNotNull((Object)suiteRunEventListener, (String)"The suiteRunEventListener must not be null");
        this.suiteRunEventListener = suiteRunEventListener;
    }

    public String getPath() {
        return this.path;
    }

    public String getParameterization() {
        return this.parameterization;
    }

    public void setBeforeSuite(BeforeSuite beforeSuite) {
        this.beforeSuiteFlow = beforeSuite;
    }

    public void addTest(Test test) {
        this.tests.add(test);
    }

    public void setAfterSuite(AfterSuite afterSuite) {
        this.afterSuiteFlow = afterSuite;
    }

    public int getNumberOfTests() {
        return this.tests.size();
    }

    public boolean allTestsIgnored() {
        return this.tests.stream().allMatch(Test::isIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuiteResult run() throws Exception {
        SuiteResult result = new SuiteResult(this.path);
        try {
            this.runBeforeSuite();
            for (Test test : this.tests) {
                this.notifyTestStart(test);
                TestResult testResult = test.run();
                result.add(testResult);
                this.notifyTestEnd(testResult);
                this.logTestResult(testResult);
            }
        }
        catch (Throwable e) {
            this.logger.error("Could not Run the suite: " + this.path, e);
        }
        finally {
            this.runAfterSuite();
        }
        return result;
    }

    private void runBeforeSuite() throws Throwable {
        String flowName = "";
        try {
            this.logger.debug("Executing Before Suite scope...");
            if (null != this.beforeSuiteFlow) {
                flowName = this.beforeSuiteFlow.getName();
                Event event = new EventBuilder(this.beforeSuiteFlow.getLocation()).build();
                this.suiteRunEventListener.notifyBeforeSuiteStart(flowName);
                this.process(this.beforeSuiteFlow, event);
                this.suiteRunEventListener.notifyBeforeSuiteEnd(flowName, "", TestStatus.SUCCESS);
            }
        }
        catch (MuleException | MuleRuntimeException e) {
            Throwable cause = e.getCause();
            this.handleBeforeSuiteEndByException(flowName, cause);
            throw cause;
        }
        catch (Throwable e) {
            this.handleBeforeSuiteEndByException(flowName, e);
            throw e;
        }
    }

    private void runAfterSuite() {
        String flowName = "";
        try {
            this.logger.debug("Executing After Suite scope...");
            if (null != this.afterSuiteFlow) {
                flowName = this.afterSuiteFlow.getName();
                Event event = new EventBuilder(this.afterSuiteFlow.getLocation()).build();
                this.suiteRunEventListener.notifyAfterSuiteStart(flowName);
                this.process(this.afterSuiteFlow, event);
                this.suiteRunEventListener.notifyAfterSuiteEnd(flowName, "", TestStatus.SUCCESS);
            }
        }
        catch (MuleException | MuleRuntimeException e) {
            Throwable cause = e.getCause();
            this.handleAfterSuiteEndByException(flowName, cause);
        }
        catch (Throwable e) {
            this.handleAfterSuiteEndByException(flowName, e);
        }
    }

    protected void handleBeforeSuiteEndByException(String flowName, Throwable cause) {
        String message = String.format("Before suite %s execution failed", flowName);
        this.logger.error(message, cause);
        String stackTrace = this.getStackTrace(cause, message);
        this.suiteRunEventListener.notifyBeforeSuiteEnd(flowName, stackTrace, this.getStatus(cause));
    }

    private void handleAfterSuiteEndByException(String flowName, Throwable cause) {
        String message = String.format("After suite %s execution failed", flowName);
        this.logger.error(message, cause);
        String stackTrace = this.getStackTrace(cause, message);
        this.suiteRunEventListener.notifyAfterSuiteEnd(flowName, stackTrace, this.getStatus(cause));
    }

    protected void process(SimpleFlow simpleFlow, Event event) throws Throwable {
        try {
            simpleFlow.execute(event).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private void notifyTestEnd(TestResult testResult) {
        this.suiteRunEventListener.notifyTestEnd(testResult.getName(), testResult.getStackTrace(), testResult.getStatus(), testResult.getElapsedTime());
    }

    private void notifyTestStart(Test test) {
        this.suiteRunEventListener.notifyTestStart(test.getName(), test.getDescription(), test.isIgnore());
    }

    private String getStackTrace(Throwable cause, String message) {
        RuntimeException e = new RuntimeException(message, cause);
        return StackTraceUtil.getStackTrace((Throwable)e);
    }

    private void logTestResult(TestResult testResult) {
        String resultMessage = String.format("%s - test: %s - Time elapsed: %.2f sec", testResult.getStatus().name(), testResult.getName(), (double)testResult.getElapsedTime() / 1000.0);
        switch (testResult.getStatus()) {
            case SUCCESS: 
            case IGNORED: {
                this.logger.info(resultMessage);
                break;
            }
            case ERROR: 
            case FAILURE: {
                this.logger.error(resultMessage);
            }
        }
    }

    private TestStatus getStatus(Throwable e) {
        return e instanceof AssertionError ? TestStatus.FAILURE : TestStatus.ERROR;
    }
}

