/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import java.util.ArrayList;
import java.util.List;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;

/**
 * <p>
 * Model that represents the list of flows to be excluded
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
@Deprecated
public class EnableFlowSources {

  protected List<FlowRef> flows = new ArrayList<>();

  public List<FlowRef> getFlows() {
    return flows;
  }

  public void setFlows(List<FlowRef> flows) {
    this.flows = flows;
  }

  /**
   * Inner object holding reference to a flow
   */
  @Alias("enableFlowSource")
  public static class FlowRef {

    @FlowReference
    @Alias("value")
    @Parameter
    private Component flow;

    public Component getFlow() {
      return flow;
    }

    public void setFlow(Component flow) {
      this.flow = flow;
    }
  }
}
