/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.remote.api.notifiers;

import java.io.IOException;
import java.io.ObjectOutput;

import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;

/**
 * The goal of this class is to notify through a outputStream all events received though the interface {@link RunMessageNotifier}
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ObjectOutputNotifier extends RunMessageNotifier {

  private ObjectOutput out;

  public ObjectOutputNotifier(String runToken, ObjectOutput out) {
    this.setRunToken(runToken);
    this.out = out;
  }

  @Override
  public void init() throws Exception {

  }

  @Override
  public void sendMessage(String message) {
    try {
      out.writeObject(message);
      out.flush();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

}
