/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.rules;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.munit.runner.component.rules.TestRule;
import org.mule.munit.runner.component.rules.TestRuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryStorageRule
implements TestRule,
Initialisable {
    public static final String OBJECT_STORE_NAME = "_munit-temporary-storage";
    @Inject
    @Named(value="_muleObjectStoreManager")
    protected ObjectStoreManager objectStoreManager;
    @Inject
    @Named(value="_muleLockFactory")
    protected LockFactory lockFactory;
    private static final Logger logger = LoggerFactory.getLogger(TemporaryStorageRule.class);
    private ObjectStore<Serializable> temporaryObjectStore;

    public void initialise() {
        ObjectStoreSettings objectStoreSettings = ObjectStoreSettings.builder().persistent(false).build();
        this.temporaryObjectStore = this.objectStoreManager.getOrCreateObjectStore(OBJECT_STORE_NAME, objectStoreSettings);
    }

    public void store(String key, Serializable value) {
        this.withLockedKey(this.temporaryObjectStore, key, objectStore -> {
            try {
                if (objectStore.contains(key)) {
                    Serializable previous = objectStore.remove(key);
                    logger.debug("Removing previous value [{}] for key [{}]", (Object)previous, (Object)key);
                }
                objectStore.store(key, value);
                logger.debug("Storing value [{}] for key [{}]", (Object)value, (Object)key);
                return null;
            }
            catch (ObjectStoreException e) {
                throw new TestRuleException(String.format("Unable to store value for key [%s]", key), e);
            }
        });
    }

    public Optional<Serializable> retrieve(String key) {
        return this.withLockedKey(this.temporaryObjectStore, key, store -> {
            try {
                Serializable value = store.retrieve(key);
                logger.debug("Getting value [{}] for key [{}]", (Object)value, (Object)key);
                return Optional.of(value);
            }
            catch (ObjectDoesNotExistException e) {
                logger.debug("No value associated with key [{}]", (Object)key);
                return Optional.empty();
            }
            catch (ObjectStoreException e) {
                throw new TestRuleException(String.format("Unable to retrieve value for key [%s]", key), e);
            }
        });
    }

    public Optional<Serializable> remove(String key) {
        return this.withLockedKey(this.temporaryObjectStore, key, store -> {
            try {
                Serializable value = store.remove(key);
                logger.debug("Removing value [{}] for key [{}]", (Object)value, (Object)key);
                return Optional.of(value);
            }
            catch (ObjectDoesNotExistException e) {
                logger.debug("No value associated with key [{}]", (Object)key);
                return Optional.empty();
            }
            catch (ObjectStoreException e) {
                throw new TestRuleException(String.format("Unable to remove value for key [%s]", key), e);
            }
        });
    }

    public void clear() {
        try {
            this.temporaryObjectStore.clear();
            logger.trace("Clearing all stored data");
        }
        catch (ObjectStoreException e) {
            throw new TestRuleException("Unable to clear stored data", e);
        }
    }

    @Override
    public void reset() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLockedKey(ObjectStore objectStore, String key, TemporaryStorageTask<T> task) {
        Lock lock = this.getKeyLock(key);
        lock.lock();
        try {
            T t = task.run(objectStore);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getKeyLock(String key) {
        return this.lockFactory.createLock("_munit-temporary-storage_" + key);
    }

    @FunctionalInterface
    private static interface TemporaryStorageTask<T> {
        public T run(ObjectStore var1);
    }
}

