/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.model;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.message.TestStatus;

/**
 * The result of each test in MUnit
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class TestResult {

  private String name;
  private String description;
  private long elapsedTime = 0;
  private String stackTrace = StringUtils.EMPTY;
  private TestStatus status = TestStatus.SUCCESS;


  public TestResult(String name, String description) {
    this.name = name;
    this.description = description;
  }

  public long getElapsedTime() {
    return elapsedTime;
  }

  public void setElapsedTime(long elapsedTime) {
    this.elapsedTime = elapsedTime;
  }

  public void setFailure(String stackTrace) {
    this.status = TestStatus.FAILURE;
    this.stackTrace = stackTrace;
  }

  public void setError(String stackTrace) {
    this.status = TestStatus.ERROR;
    this.stackTrace = stackTrace;
  }

  public void setSkipped() {
    this.status = TestStatus.IGNORED;
  }

  public void setSuccess() {
    this.status = TestStatus.SUCCESS;
  }

  public TestStatus getStatus() {
    return status;
  }

  public String getStackTrace() {
    return stackTrace;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }
}
