/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.common.api.model.stereotype.MUnitStereotypes;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.builders.SuiteBuilder;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.module.embedded.api.Product;

public class SuiteBuilderWithArtifactAstTest {
    private static final String SUITE_PATH = "suitePath";
    private static final String SUITE_PARAMETERIZATION = "param1";
    private SuiteBuilder builder;
    private MunitModule munitModuleMock;
    private TestComponentLocator componentLocatorMock;
    private TestFlow testFlowMock;
    private ComponentAst testComponentAstMock;
    private HasStereotypeModel testProcessorStereotypeModelMock;
    private ComponentParameterAst minMuleVersionParameterMock;
    private ComponentParameterAst requiredProductParameterMock;
    private ComponentParameterAst ignoreParameterMock;
    private ComponentParameterAst tagsParameterMock;

    @Before
    public void setUp() {
        this.munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        this.componentLocatorMock = (TestComponentLocator)Mockito.mock(TestComponentLocator.class);
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)this.componentLocatorMock.lookupMunitModule()).thenReturn(Optional.of(this.munitModuleMock));
        Mockito.when((Object)this.componentLocatorMock.lookupBeforeSuite()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupAfterSuite()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupBeforeTest()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupAfterTest()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocatorMock.lookupTests()).thenReturn(Collections.singletonList(this.testFlowMock));
        this.testComponentAstMock = (ComponentAst)Mockito.mock(ComponentAst.class);
        DefaultComponentLocation testLocationMock = DefaultComponentLocation.fromSingleComponent((String)"test_name").appendLocationPart("", Optional.empty(), Optional.of(SUITE_PATH), OptionalInt.empty(), OptionalInt.empty());
        Mockito.when((Object)this.testComponentAstMock.getLocation()).thenReturn((Object)testLocationMock);
        Mockito.when((Object)this.testComponentAstMock.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"munit:config"));
        Mockito.when((Object)this.testComponentAstMock.getComponentId()).thenReturn(Optional.of("test_name"));
        Mockito.when((Object)this.testComponentAstMock.recursiveStream()).thenAnswer(inv -> Stream.of(this.testComponentAstMock));
        this.testProcessorStereotypeModelMock = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)this.testComponentAstMock.getModel(HasStereotypeModel.class)).thenReturn(Optional.of(this.testProcessorStereotypeModelMock));
        this.minMuleVersionParameterMock = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.minMuleVersionParameterMock.getValue()).thenReturn((Object)Either.empty());
        this.requiredProductParameterMock = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.requiredProductParameterMock.getValue()).thenReturn((Object)Either.right((Object)Product.MULE.name()));
        this.ignoreParameterMock = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.ignoreParameterMock.getValue()).thenReturn((Object)Either.right((Object)false));
        this.tagsParameterMock = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.tagsParameterMock.getValue()).thenReturn((Object)Either.empty());
        Mockito.when((Object)this.testComponentAstMock.getParameter("General", "minMuleVersion")).thenReturn((Object)this.minMuleVersionParameterMock);
        Mockito.when((Object)this.testComponentAstMock.getParameter("General", "requiredProduct")).thenReturn((Object)this.requiredProductParameterMock);
        Mockito.when((Object)this.testComponentAstMock.getParameter("General", "ignore")).thenReturn((Object)this.ignoreParameterMock);
        Mockito.when((Object)this.testComponentAstMock.getParameter("General", "tags")).thenReturn((Object)this.tagsParameterMock);
        ArtifactAst testArtifactAstMock = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)testArtifactAstMock.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(this.testComponentAstMock));
        DefaultComponentLocation.DefaultLocationPart part = (DefaultComponentLocation.DefaultLocationPart)Mockito.mock(DefaultComponentLocation.DefaultLocationPart.class);
        Mockito.when((Object)part.getFileName()).thenReturn(Optional.of(SUITE_PATH));
        this.builder = new SuiteBuilder(SUITE_PATH, SUITE_PARAMETERIZATION, this.componentLocatorMock, Optional.of(testArtifactAstMock));
    }

    @Test(expected=IllegalStateException.class)
    public void illegalArgumentIfMunitModuleNotPresent() {
        Mockito.when((Object)this.componentLocatorMock.lookupMunitModule()).thenReturn(Optional.empty());
        this.builder.build();
    }

    @Test
    public void testBuildBlankTestToRunName() {
        this.builder.withTestNames(Collections.emptyList());
        this.assertNumberOfTests(this.builder.build(), 1);
    }

    @Test
    public void testBuildMunitTestsIsIgnored() {
        Mockito.reset((Object[])new ComponentParameterAst[]{this.ignoreParameterMock});
        Mockito.when((Object)this.ignoreParameterMock.getValue()).thenReturn((Object)Either.right((Object)true));
        this.assertNumberOfTests(this.builder.build(), 1);
    }

    @Test
    public void testBuildMunitTestsNameDoesntMatchShouldIgnore() {
        this.builder.withTestNames(Arrays.asList(RunConfiguration.Test.of((String)SUITE_PATH, (String)"not_matching_test_name")));
        this.assertNumberOfTests(this.builder.build(), 0);
    }

    @Test
    public void testBuildMunitTestsDoesntMatchTagsShouldIgnore() {
        Mockito.reset((Object[])new ComponentParameterAst[]{this.tagsParameterMock});
        Mockito.when((Object)this.tagsParameterMock.getValue()).thenReturn((Object)Either.right((Object)"oneTag"));
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton("otherTag"));
        this.assertNumberOfTests(this.builder.build(), 0);
    }

    @Test
    public void testBuildMunitTestsMatchesSameTagShouldNotIgnore() {
        Mockito.reset((Object[])new ComponentParameterAst[]{this.tagsParameterMock});
        Mockito.when((Object)this.tagsParameterMock.getValue()).thenReturn((Object)Either.right((Object)"oneTag"));
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton("oneTag"));
        this.assertNumberOfTests(this.builder.build(), 1);
    }

    @Test
    public void testBuildMunitTestsMatchesSameImplicitTagShouldNotIgnore() {
        Mockito.reset((Object[])new HasStereotypeModel[]{this.testProcessorStereotypeModelMock});
        Mockito.when((Object)this.testProcessorStereotypeModelMock.getStereotype()).thenReturn((Object)MUnitStereotypes.TEST_PROCESSOR);
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton(MUnitStereotypes.TEST_PROCESSOR.getNamespace() + ":" + MUnitStereotypes.TEST_PROCESSOR.getType()));
        this.assertNumberOfTests(this.builder.build(), 1);
    }

    private void assertNumberOfTests(Suite suite, int numberOfTests) {
        MatcherAssert.assertThat((Object)suite.getNumberOfTests(), (Matcher)CoreMatchers.equalTo((Object)numberOfTests));
    }
}

