/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.notifiers;

import java.io.PrintStream;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.model.SuiteResult;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.remote.api.notifiers.StreamNotifier;

public class StreamNotifierTest {
    private static final String EXAMPLE_STACKTRACE = "EXAMPLE_STACKTRACE";
    private TestResult testResult;
    private SuiteResult suiteResult;
    private Test test;
    private PrintStream out;
    private StreamNotifier listener;
    private String stackTrace;

    @Before
    public void setUp() {
        this.out = (PrintStream)Mockito.mock(PrintStream.class);
        this.testResult = (TestResult)Mockito.mock(TestResult.class);
        this.test = (Test)Mockito.mock(Test.class);
        this.suiteResult = (SuiteResult)Mockito.mock(SuiteResult.class);
        this.listener = new StreamNotifier(this.out);
        this.stackTrace = EXAMPLE_STACKTRACE;
    }

    @org.junit.Test
    public void verifyStreamWhenNoErrorsAndFailureIsNull() {
        this.listener.notifyTestEnd(this.testResult.getName(), this.testResult.getStackTrace(), TestStatus.SUCCESS, this.testResult.getElapsedTime(), "");
        ((PrintStream)Mockito.verify((Object)this.out)).flush();
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.never())).println(Mockito.anyString());
    }

    @org.junit.Test
    public void verifyStreamWhenNoErrorsAndFailureIsNotNull() {
        Mockito.when((Object)this.testResult.getStackTrace()).thenReturn((Object)this.stackTrace);
        this.listener.notifyTestEnd(this.testResult.getName(), this.testResult.getStackTrace(), TestStatus.FAILURE, this.testResult.getElapsedTime(), "");
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)1))).flush();
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)3))).println(Mockito.anyString());
    }

    @org.junit.Test
    public void verifyStreamWhenTestIsSkipped() {
        this.listener.notifyTestStart(this.testResult.getName(), this.testResult.getDescription(), true, "");
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)1))).flush();
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)3))).println(Mockito.anyString());
    }

    @org.junit.Test
    public void verifyStreamWhenTestResultIsSkipped() {
        Mockito.when((Object)this.testResult.getStatus()).thenReturn((Object)TestStatus.IGNORED);
        this.listener.notifyTestEnd(this.testResult.getName(), this.testResult.getStackTrace(), TestStatus.IGNORED, this.testResult.getElapsedTime(), "");
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)1))).flush();
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.never())).println(Mockito.anyString());
    }

    @org.junit.Test
    public void verifyStreamWhenErrorsExistButNoStackTrace() {
        this.listener.notifyTestEnd(this.testResult.getName(), this.testResult.getStackTrace(), TestStatus.ERROR, this.testResult.getElapsedTime(), "");
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)1))).flush();
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.never())).println(Mockito.anyString());
    }

    @org.junit.Test
    public void verifyStreamWhenNotifyingEnd() {
        this.listener.notifySuiteEnd(this.suiteResult.getTestName(), "", this.suiteResult.getElapsedTime());
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)1))).flush();
        ((PrintStream)Mockito.verify((Object)this.out, (VerificationMode)Mockito.times((int)3))).println(Mockito.anyString());
    }
}

