/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.runner.remote.api.server.RunnerServer;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;

public class RunnerServerTest {
    private static final int MIN_PORT_NUMBER = 40000;
    private static final int MAX_PORT_NUMBER = 50000;
    private RunnerServer runnerServer;
    private Scheduler schedulerMock;
    private Gson gson = new Gson();
    private int port;
    private FreePortFinder freePortFinder = new FreePortFinder(40000, 50000);

    @Before
    public void setUp() throws IOException, InitialisationException, ClassNotFoundException {
        RunnerServer runnerServer = new RunnerServer();
        runnerServer.setTestComponentInfoProviders(Collections.emptyList());
        this.runnerServer = (RunnerServer)Mockito.spy((Object)runnerServer);
        Registry muleRegistry = (Registry)Mockito.mock(Registry.class);
        SchedulerService schedulerServiceMock = (SchedulerService)Mockito.mock(SchedulerService.class);
        this.schedulerMock = (Scheduler)Mockito.mock(Scheduler.class);
        Mockito.when((Object)schedulerServiceMock.customScheduler((SchedulerConfig)ArgumentMatchers.any(SchedulerConfig.class))).thenReturn((Object)this.schedulerMock);
        this.runnerServer.setSchedulerService(schedulerServiceMock);
        this.runnerServer.setComponentLocator((ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class));
        this.runnerServer.setTestComponentInfoProviders(Collections.emptyList());
        ((RunnerServer)Mockito.doNothing().when((Object)this.runnerServer)).handleClientMessage((ObjectInput)ArgumentMatchers.any(ObjectInput.class), (ObjectOutput)ArgumentMatchers.any(ObjectOutput.class));
        this.port = this.freePortFinder.find();
    }

    @Test
    public void initialiseSchedulesRunnerServer() throws MuleException {
        System.setProperty("munit.server.port", String.valueOf(this.port));
        this.runnerServer.initialise();
        this.runnerServer.start();
        ((Scheduler)Mockito.verify((Object)this.schedulerMock)).submit((Runnable)this.runnerServer);
    }

    @Test
    public void receivesMessageFromClient() throws IOException, ClassNotFoundException, InterruptedException {
        System.setProperty("munit.server.port", String.valueOf(this.port));
        Executors.newSingleThreadExecutor().execute((Runnable)this.runnerServer);
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).untilAsserted(this::sendWithClient);
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).untilAsserted(() -> ((RunnerServer)Mockito.verify((Object)this.runnerServer)).handleClientMessage((ObjectInput)ArgumentMatchers.any(ObjectInput.class), (ObjectOutput)ArgumentMatchers.any(ObjectOutput.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPort() throws IOException, ClassNotFoundException {
        System.setProperty("munit.server.port", "-1");
        this.runnerServer.run();
    }

    @Test
    public void ioExceptionStopsRun() throws IOException, ClassNotFoundException {
        IOException toBeThrown = new IOException();
        ((RunnerServer)Mockito.doThrow((Throwable[])new Throwable[]{toBeThrown}).when((Object)this.runnerServer)).createServerSocket();
        this.runnerServer.run();
        MatcherAssert.assertThat((Object)this.runnerServer.isKeepRunning(), (Matcher)Matchers.equalTo((Object)false));
        ((RunnerServer)Mockito.verify((Object)this.runnerServer, (VerificationMode)Mockito.never())).handleClientMessage((ObjectInput)ArgumentMatchers.any(ObjectInput.class), (ObjectOutput)ArgumentMatchers.any(ObjectOutput.class));
    }

    @Test
    public void socketTimeoutExceptionStopsRun() throws IOException, ClassNotFoundException {
        ServerSocket socketMock = (ServerSocket)Mockito.mock(ServerSocket.class);
        SocketTimeoutException toBeThrown = new SocketTimeoutException();
        ((RunnerServer)Mockito.doReturn((Object)socketMock).when((Object)this.runnerServer)).createServerSocket();
        ((ServerSocket)Mockito.doThrow((Throwable[])new Throwable[]{toBeThrown}).when((Object)socketMock)).accept();
        this.runnerServer.run();
        MatcherAssert.assertThat((Object)this.runnerServer.isKeepRunning(), (Matcher)Matchers.equalTo((Object)false));
        ((RunnerServer)Mockito.verify((Object)this.runnerServer, (VerificationMode)Mockito.never())).handleClientMessage((ObjectInput)ArgumentMatchers.any(ObjectInput.class), (ObjectOutput)ArgumentMatchers.any(ObjectOutput.class));
    }

    @Test
    public void onStopCloseSocket() throws IOException, MuleException, InterruptedException {
        ServerSocket socketMock = (ServerSocket)Mockito.mock(ServerSocket.class);
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        InputStream in = (InputStream)Mockito.mock(InputStream.class);
        InetAddress address = InetAddress.getLocalHost();
        Socket socket = (Socket)Mockito.mock(Socket.class);
        ((RunnerServer)Mockito.doReturn((Object)socketMock).when((Object)this.runnerServer)).createServerSocket();
        ((Socket)Mockito.doReturn((Object)out).when((Object)socket)).getOutputStream();
        ((Socket)Mockito.doReturn((Object)in).when((Object)socket)).getInputStream();
        ((Socket)Mockito.doReturn((Object)address).when((Object)socket)).getInetAddress();
        ((ServerSocket)Mockito.doReturn((Object)socket).when((Object)socketMock)).accept();
        Executors.newSingleThreadExecutor().execute((Runnable)this.runnerServer);
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).untilAsserted(() -> ((RunnerServer)Mockito.verify((Object)this.runnerServer)).createServerSocket());
        this.runnerServer.stop();
        ((ServerSocket)Mockito.verify((Object)socketMock)).close();
    }

    @After
    public void tearDown() throws MuleException {
        this.runnerServer.stop();
        this.runnerServer.dispose();
    }

    private void sendWithClient() throws IOException {
        RunnerClient runnerClient = new RunnerClient(this.port);
        runnerClient.sendMessage(64, Collections.singletonMap("key", "value"));
    }

    private class RunnerClient {
        private ObjectOutputStream out;

        RunnerClient(int port) throws IOException {
            Socket requestSocket = new Socket("localhost", port);
            this.out = new ObjectOutputStream(requestSocket.getOutputStream());
        }

        void sendMessage(Integer id, Map<String, String> params) throws IOException {
            this.out.writeObject(RunnerServerTest.this.gson.toJson((Object)new RunMessage(id, params)));
            this.out.flush();
        }
    }
}

