/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.munit.runner.component.factory.TestProcessorChainFactory;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;

public class TestProcessorChainFactoryTest {
    @InjectMocks
    private TestProcessorChainFactory factory;
    @Mock
    private PrivilegedMuleContext muleContext;
    @Mock
    private ConfigurationComponentLocator configurationComponentLocator;
    @Mock
    private ProcessingStrategyFactory processingStrategyFactory;
    @Mock
    private Location rootContainerLocation;
    @Mock
    private TestFlow testFlow;
    @Mock
    private Processor processor;
    private List<Object> processors;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.processors = new ArrayList<Object>();
        this.factory.setMessageProcessors(this.processors);
        this.factory.setName("TestChain");
        Mockito.when((Object)this.muleContext.getConfigurationComponentLocator()).thenReturn((Object)this.configurationComponentLocator);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)((MuleConfiguration)Mockito.mock(MuleConfiguration.class)));
        Mockito.when((Object)this.muleContext.getConfiguration().getDefaultProcessingStrategyFactory()).thenReturn((Object)this.processingStrategyFactory);
        Mockito.when((Object)this.configurationComponentLocator.find(this.rootContainerLocation)).thenReturn(Optional.of(this.testFlow));
        Mockito.when((Object)this.processingStrategyFactory.create((MuleContext)this.muleContext, "TestChain")).thenReturn((Object)((ProcessingStrategy)Mockito.mock(ProcessingStrategy.class)));
    }

    @Test
    public void testDoGetObject_ValidProcessors() throws Exception {
        this.processors.add(this.processor);
        MessageProcessorChain result = this.factory.doGetObject();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testDoGetObject_InvalidProcessor() throws Exception {
        this.processors.add("InvalidProcessor");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured.");
        this.factory.doGetObject();
    }

    @Test
    public void testSetMessageProcessors() {
        ArrayList<Processor> newProcessors = new ArrayList<Processor>();
        newProcessors.add(this.processor);
        this.factory.setMessageProcessors(newProcessors);
        Assert.assertEquals((long)1L, (long)this.factory.processors.size());
        Assert.assertSame((Object)this.processor, this.factory.processors.get(0));
    }

    @Test
    public void testSetName() {
        this.factory.setName("NewName");
        Assert.assertEquals((Object)"NewName", (Object)this.factory.name);
    }

    @Test
    public void testGetBuilderInstance() {
        DefaultMessageProcessorChainBuilder builder = this.factory.getBuilderInstance();
        Assert.assertNotNull((Object)builder);
    }

    @Test
    public void testGetProcessingStrategy_ValidCase() throws Exception {
        ArrayList<Processor> processors1 = new ArrayList<Processor>();
        processors1.add(this.processor);
        this.factory.setMessageProcessors(processors1);
        MessageProcessorChain result = this.factory.doGetObject();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testFindTest_ValidTestFlow() throws Exception {
        Mockito.when((Object)this.configurationComponentLocator.find(this.rootContainerLocation)).thenReturn(Optional.of(this.testFlow));
        Method findTestMethod = TestProcessorChainFactory.class.getDeclaredMethod("findTest", ConfigurationComponentLocator.class, Location.class);
        findTestMethod.setAccessible(true);
        TestFlow result = (TestFlow)findTestMethod.invoke((Object)this.factory, this.configurationComponentLocator, this.rootContainerLocation);
        Assert.assertNotNull((Object)result);
        Assert.assertSame((Object)this.testFlow, (Object)result);
    }

    @Test
    public void testFindTest_NoTestFlow() throws Exception {
        Mockito.when((Object)this.configurationComponentLocator.find(this.rootContainerLocation)).thenReturn(Optional.empty());
        Method findTestMethod = TestProcessorChainFactory.class.getDeclaredMethod("findTest", ConfigurationComponentLocator.class, Location.class);
        findTestMethod.setAccessible(true);
        try {
            findTestMethod.invoke((Object)this.factory, this.configurationComponentLocator, this.rootContainerLocation);
            Assert.fail((String)"Expected IllegalStateException to be thrown");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof IllegalStateException));
            Assert.assertTrue((boolean)cause.getMessage().contains("Chain was expected to belong to a test. Root container was"));
        }
    }
}

