/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.functions;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.munit.runner.functions.MunitFunctionsBindingContextProvider;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.TypedValue;

public class MunitFunctionsBindingContextProviderTest {
    @InjectMocks
    private MunitFunctionsBindingContextProvider bindingContextProvider;
    @Mock
    private ConfigurationProperties configurationProperties;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.configurationProperties.resolveStringProperty(Mockito.anyString())).thenReturn(Optional.of("test-value"));
        Mockito.when((Object)this.configurationProperties.resolveBooleanProperty(Mockito.anyString())).thenReturn(Optional.of(true));
        Mockito.when((Object)this.configurationProperties.resolveProperty(Mockito.anyString())).thenReturn(Optional.empty());
    }

    @Test
    public void testGetBindingContext() {
        BindingContext bindingContext = this.bindingContextProvider.getBindingContext();
        Assert.assertNotNull((Object)bindingContext);
    }

    @Test
    public void testMunitExpressionModule() {
        BindingContext bindingContext = this.bindingContextProvider.getBindingContext();
        Assert.assertNotNull((Object)bindingContext);
        bindingContext.modules().stream().findAny().ifPresent(module -> Assert.assertFalse((boolean)module.bindings().isEmpty()));
        bindingContext.modules().stream().findAny().ifPresent(module -> Assert.assertFalse((boolean)module.identifiers().isEmpty()));
        bindingContext.modules().stream().findAny().ifPresent(module -> Assert.assertTrue((boolean)module.lookup("osEqualTo").isPresent()));
        bindingContext.modules().stream().findAny().ifPresent(module -> Assert.assertEquals((Object)module.namespace().toString(), (Object)"Munit"));
    }

    @Test
    public void testGetBindings() throws Exception {
        Map<String, TypedValue> bindings = this.invokePrivateMethod("getBindings");
        Assert.assertNotNull(bindings);
        Assert.assertEquals((long)4L, (long)bindings.size());
        Assert.assertTrue((boolean)bindings.containsKey("osEqualTo"));
        Assert.assertTrue((boolean)bindings.containsKey("muleVersionPriorTo"));
        Assert.assertTrue((boolean)bindings.containsKey("muleVersionNewerThan"));
        Assert.assertTrue((boolean)bindings.containsKey("muleVersionEqualTo"));
    }

    @Test
    public void testLookupFunction() throws Exception {
        Map<String, TypedValue> bindings = this.invokePrivateMethod("getBindings");
        Assert.assertTrue((boolean)bindings.containsKey("osEqualTo"));
        Assert.assertNotNull((Object)bindings.get("osEqualTo"));
    }

    private Map<String, TypedValue> invokePrivateMethod(String methodName) throws Exception {
        Method method = MunitFunctionsBindingContextProvider.class.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return (Map)method.invoke((Object)this.bindingContextProvider, new Object[0]);
    }
}

