/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.assertion;

import org.junit.Assert;
import org.mule.munit.assertion.api.MunitAssertion;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.internal.AssertModule;
import org.mule.munit.assertion.internal.HamcrestFactory;
import org.mule.munit.common.exception.MunitError;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AssertOperations {
    private static final String RUN_CUSTOM_ERROR = "The assert:run-custom MP assertion requires a class implementing %s Please provide one.";
    private AssertModule assertModule = new AssertModule();

    @Summary(value="Perform an assertion over an expression")
    public void assertThat(TypedValue<?> expression, Matcher is, @Optional(defaultValue="") String message) {
        this.assertModule.assertThat(message, expression, HamcrestFactory.create((Matcher)is));
    }

    @Summary(value="Fail with an assertion")
    public void fail(@Optional(defaultValue="") String message) {
        Assert.fail((String)message);
    }

    @Summary(value="Run a custom assertion")
    public void runCustom(MunitAssertion assertion, TypedValue<Object> expression, @Optional Object params) {
        if (null == assertion) {
            throw new MunitError(String.format(RUN_CUSTOM_ERROR, MunitAssertion.class.getCanonicalName()));
        }
        assertion.execute(expression, params);
    }

    protected void setAssertModule(AssertModule assertModule) {
        this.assertModule = assertModule;
    }
}

