/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools;

import javax.inject.Inject;

import org.mule.munit.assertion.internal.functions.BothFunction;
import org.mule.munit.assertion.internal.functions.EitherFunction;
import org.mule.munit.assertion.internal.functions.EqualToFunction;
import org.mule.munit.assertion.internal.functions.NotFunction;
import org.mule.munit.assertion.internal.functions.NotNullValueFunction;
import org.mule.munit.assertion.internal.functions.NullValueFunction;
import org.mule.munit.assertion.internal.functions.WithEncodingFunction;
import org.mule.munit.assertion.internal.functions.WithMediaTypeFunction;
import org.mule.munit.common.el.MunitExpressionFunction;
import org.mule.munit.common.el.utils.GetBeanFromMuleContextFunction;
import org.mule.munit.common.el.utils.GetResourceAsByteArrayFunction;
import org.mule.munit.common.el.utils.GetResourceAsReusableStreamFunction;
import org.mule.munit.common.el.utils.GetResourceAsStreamFunction;
import org.mule.munit.common.el.utils.GetResourceAsStringFunction;
import org.mule.munit.common.el.utils.GetResourceFunction;
import org.mule.munit.common.el.utils.SamePayloadFunction;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.GlobalBindingContextProvider;

public class MunitBindingContextProvider implements GlobalBindingContextProvider {

  @Inject
  private MuleContext muleContext;

  @Override
  public BindingContext getBindingContext() {
    BindingContext.Builder builder = BindingContext.builder();
    addAssertionFunctions(builder);
    addResourceFunctions(builder);
    addMockFunctions(builder);

    addBinding(builder, new GetBeanFromMuleContextFunction(muleContext));

    return builder.build();
  }

  private void addMockFunctions(BindingContext.Builder builder) {
    addBinding(builder, new SamePayloadFunction());
  }

  private void addResourceFunctions(BindingContext.Builder builder) {
    addBinding(builder, new GetResourceFunction());
    addBinding(builder, new GetResourceAsByteArrayFunction());
    addBinding(builder, new GetResourceAsStringFunction());
    addBinding(builder, new GetResourceAsStreamFunction());
    addBinding(builder, new GetResourceAsReusableStreamFunction());
  }

  private void addAssertionFunctions(BindingContext.Builder builder) {
    addBinding(builder, new NullValueFunction());
    addBinding(builder, new NotNullValueFunction());
    addBinding(builder, new EqualToFunction());
    addBinding(builder, new WithEncodingFunction());
    addBinding(builder, new WithMediaTypeFunction());
    addBinding(builder, new NotFunction());
    addBinding(builder, new BothFunction());
    addBinding(builder, new EitherFunction());
  }

  private void addBinding(BindingContext.Builder builder, MunitExpressionFunction function) {
    builder.addBinding(function.getName(), function.asTypedValue());
  }
}
