package org.mule.munit.tools.mock;

import javax.inject.Inject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.mock.interception.MunitProcessorInterceptor;
import org.mule.munit.mock.interception.MunitProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;

/**
 * The goal of this class is to wire the ProcessorInterceptorFactory with a BehaviorManager and register the factory.
 */
public class MockProcessorManagerProvider implements Initialisable {

  private transient Log logger = LogFactory.getLog(this.getClass());

  @Inject
  private MuleContext muleContext;

  @Inject
  private BehaviorManager behaviorManager;

  @Override
  public void initialise() throws InitialisationException {
    logger.debug("Initialising MockProcessorManagerProvider...");
    logger.debug("Adding " + MunitProcessorInterceptor.class.getName() + " to processor interceptor manager");

    MunitProcessorInterceptorFactory interceptorFactory = new MunitProcessorInterceptorFactory();
    interceptorFactory.setBehaviorManager(behaviorManager);
    interceptorFactory.setErrorTypeRepository(muleContext.getErrorTypeRepository());
    muleContext.getProcessorInterceptorManager().addInterceptorFactory(interceptorFactory);
  }

  protected void setMuleContext(MuleContext muleContext) {
    this.muleContext = muleContext;
  }

  protected void setBehaviorManager(BehaviorManager behaviorManager) {
    this.behaviorManager = behaviorManager;
  }
}
