/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.mock;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.model.Attribute;
import org.mule.munit.common.model.Event;
import org.mule.munit.mock.MockModule;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class MockOperations {
    @Inject
    private MuleContext muleContext;
    private MockModule mockModule = new MockModule();

    @Summary(value="Mock the Processor when it matches processor name and attributes")
    public void mockWhen(@Example(value="http:request") String processor, @Optional @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @Optional @Expression(value=ExpressionSupport.NOT_SUPPORTED) Event thenReturn) {
        this.validateErrorInEvent(thenReturn);
        this.mockModule.setMuleContext(this.muleContext);
        this.mockModule.when(processor, withAttributes, thenReturn);
    }

    @Summary(value="Verify that a processor is called")
    public void verifyCall(@Example(value="mule:logger") String processor, @Optional @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @Optional Integer times, @Optional Integer atLeast, @Optional Integer atMost) {
        if (null == times && null == atLeast && null == atMost) {
            times = 1;
        }
        this.mockModule.setMuleContext(this.muleContext);
        this.mockModule.verifyCall(processor, withAttributes, times, atLeast, atMost);
    }

    protected void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected void setMockModule(MockModule mockModule) {
        this.mockModule = mockModule;
    }

    private void validateErrorInEvent(Event thenReturn) {
        if (thenReturn != null && thenReturn.getError() != null && StringUtils.isNotBlank((CharSequence)thenReturn.getError().getTypeId()) && thenReturn.getError().getCause() != null) {
            throw new IllegalArgumentException("Mocked event's error failure. The attributes typeId and cause are mutually exclusive. Please define only one of them");
        }
    }
}

