/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools;

import javax.inject.Inject;

import org.mule.munit.assertion.internal.functions.*;
import org.mule.munit.common.el.MunitExpressionFunction;
import org.mule.munit.common.el.utils.*;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.GlobalBindingContextProvider;

/**
 * <p>
 * Provides a binding context with the registered DW functions as global
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MunitBindingContextProvider implements GlobalBindingContextProvider {

  @Inject
  private MuleContext muleContext;

  @Override
  public BindingContext getBindingContext() {
    BindingContext.Builder builder = BindingContext.builder();
    addAssertionFunctions(builder);
    addResourceFunctions(builder);

    return builder.build();
  }

  private void addResourceFunctions(BindingContext.Builder builder) {
    addBinding(builder, new GetResourceAsByteArrayFunction());
    addBinding(builder, new GetResourceAsStringFunction());
    addBinding(builder, new GetResourceAsStreamFunction());
    addBinding(builder, new GetResourceAsReusableStreamFunction());
  }

  private void addAssertionFunctions(BindingContext.Builder builder) {
    addBinding(builder, new NullValueFunction());
    addBinding(builder, new NotNullValueFunction());
    addBinding(builder, new EqualToFunction());
    addBinding(builder, new WithEncodingFunction());
    addBinding(builder, new WithMediaTypeFunction());
    addBinding(builder, new NotFunction());
    addBinding(builder, new BothFunction());
    addBinding(builder, new EitherFunction());
    addBinding(builder, new MatchesFunction());
  }

  private void addBinding(BindingContext.Builder builder, MunitExpressionFunction function) {
    builder.addBinding(function.getName(), function.asTypedValue());
  }
}
