/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.mock;

import javax.inject.Inject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.mock.interception.MunitProcessorInterceptor;
import org.mule.munit.mock.interception.MunitProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.Config;

/**
 * The goal of this class is to wire the ProcessorInterceptorFactory with a BehaviorManager and register the factory.
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MockProcessorManagerProvider implements Initialisable, Config {

  private transient Log logger = LogFactory.getLog(this.getClass());

  @Inject
  private MuleContext muleContext;

  @Inject
  private BehaviorManager behaviorManager;

  @Override
  public void initialise() throws InitialisationException {
    logger.debug("Initialising MockProcessorManagerProvider...");
    logger.debug("Adding " + MunitProcessorInterceptor.class.getName() + " to processor interceptor manager");

    MunitProcessorInterceptorFactory interceptorFactory = new MunitProcessorInterceptorFactory();
    interceptorFactory.setBehaviorManager(behaviorManager);
    interceptorFactory.setErrorTypeRepository(muleContext.getErrorTypeRepository());
    muleContext.getProcessorInterceptorManager().addInterceptorFactory(interceptorFactory);
  }

  protected void setMuleContext(MuleContext muleContext) {
    this.muleContext = muleContext;
  }

  protected void setBehaviorManager(BehaviorManager behaviorManager) {
    this.behaviorManager = behaviorManager;
  }
}
