/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.assertion.functions;

import java.nio.charset.Charset;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.api.matchers.core.BothMatcher;
import org.mule.munit.assertion.api.matchers.core.EitherMatcher;
import org.mule.munit.assertion.api.matchers.core.EqualToMatcher;
import org.mule.munit.assertion.api.matchers.core.NotMatcher;
import org.mule.munit.assertion.api.matchers.core.NotNullValueMatcher;
import org.mule.munit.assertion.api.matchers.core.NullValueMatcher;
import org.mule.munit.assertion.api.matchers.core.WithEncodingMatcher;
import org.mule.munit.assertion.api.matchers.core.WithMediaTypeMatcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class CoreMatcherFunctions {
    @Summary(value="Matches if expression equals a value")
    public Matcher equalTo(Object value) {
        return new EqualToMatcher(value);
    }

    @Summary(value="Matches if expression value is not null")
    public Matcher notNullValue() {
        return new NotNullValueMatcher();
    }

    @Summary(value="Matches if expression value is null")
    public Matcher nullValue() {
        return new NullValueMatcher();
    }

    @Summary(value="Matches if expression does not match the given matcher")
    public Matcher not(Matcher matcher) {
        return new NotMatcher(matcher);
    }

    @Summary(value="Matches if expression matches both given matchers")
    public Matcher both(Matcher first, Matcher second) {
        return new BothMatcher(first, second);
    }

    @Summary(value="Matches if expression matches at least one of the given matchers")
    public Matcher either(Matcher first, Matcher second) {
        return new EitherMatcher(first, second);
    }

    @Summary(value="Matches if the expression has a particular encoding")
    public Matcher withEncoding(@Optional @Example(value="UTF-8") String encoding) {
        return new WithEncodingMatcher(encoding == null ? null : Charset.forName(encoding));
    }

    @Summary(value="Matches if the expression has a particular media type")
    public Matcher withMediaType(@Example(value="text/xml") String mediaType) {
        return new WithMediaTypeMatcher(mediaType == null ? null : MediaType.parse((String)mediaType));
    }
}

