/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.util;

import java.io.InputStream;
import org.mule.munit.tools.util.MunitResource;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class GetResourceFunctions {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    @Summary(value="Get resource as a byte array")
    public byte[] getResourceAsByteArray(@Example(value="example.json") String path) {
        return new MunitResource(path, this.classLoader).asByteArray();
    }

    @Summary(value="Get resource as a string")
    public String getResourceAsString(@Example(value="example.json") String path) {
        return new MunitResource(path, this.classLoader).asString();
    }

    @Summary(value="Get resource as a stream")
    public InputStream getResourceAsStream(@Example(value="example.json") String path) {
        return new MunitResource(path, this.classLoader).asStream();
    }

    @Summary(value="Get resource as a stream that can be read multiple times")
    public InputStream getResourceAsReusableStream(@Example(value="example.json") String path) {
        return new MunitResource(path, this.classLoader).asReusableStream();
    }
}

