/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion.functions;

import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.api.matchers.string.MatchRegexMatcher;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

/**
 * Functions to perform assertions over strings
 * 
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class StringMatcherFunctions {


  @Summary("Matches if expression matches the given regular expression")
  public Matcher matches(String regex) {
    return new MatchRegexMatcher(regex);
  }

}
