/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import java.io.InputStream;

import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

/**
 * Utility functions to handle resources
 * 
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class GetResourceFunctions {

  private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

  @Summary("Get resource as a byte array")
  public byte[] getResourceAsByteArray(@Example("example.json") String path) {
    return new MunitResource(path, classLoader).asByteArray();
  }

  @Summary("Get resource as a string")
  public String getResourceAsString(@Example("example.json") String path) {
    return new MunitResource(path, classLoader).asString();
  }

  @Summary("Get resource as a stream")
  public InputStream getResourceAsStream(@Example("example.json") String path) {
    return new MunitResource(path, classLoader).asStream();
  }

  @Summary("Get resource as a stream that can be read multiple times")
  public InputStream getResourceAsReusableStream(@Example("example.json") String path) {
    return new MunitResource(path, classLoader).asReusableStream();
  }

}
