/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.assertion;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.mule.munit.assertion.api.MunitAssertion;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.internal.AssertModule;
import org.mule.munit.assertion.internal.HamcrestFactory;
import org.mule.munit.common.exception.MunitError;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AssertOperations {
    private static final String RUN_CUSTOM_INTERFACE_ERROR = "The run-custom operation requires a class implementing %s. Please provide one.";
    private static final String RUN_CUSTOM_ERROR = "Unable to create custom assertion";
    private static final String MUNIT_ASSERTION_CLASS = "org.mule.munit.assertion.api.MunitAssertion";
    private AssertModule assertModule = new AssertModule();

    @Summary(value="Perform an assertion over an expression")
    public void assertThat(@Example(value="#[payload]") TypedValue<?> expression, @Expression(value=ExpressionSupport.REQUIRED) @Example(value="#[MunitTools::notNullValue()]") Matcher is, @Optional(defaultValue="") String message) {
        this.assertModule.assertThat(message, expression, HamcrestFactory.create((Matcher)is));
    }

    @Summary(value="Fail with an assertion")
    public void fail(@Optional(defaultValue="") String message) {
        Assert.fail((String)message);
    }

    @Summary(value="Run a custom assertion")
    public void runCustom(@Example(value="com.example.CustomAssertion") @ClassValue(extendsOrImplements={"org.mule.munit.assertion.api.MunitAssertion"}) String assertion, @Example(value="#[payload]") TypedValue<Object> expression, @Optional Object params) {
        if (StringUtils.isBlank((CharSequence)assertion)) {
            throw new MunitError(String.format(RUN_CUSTOM_INTERFACE_ERROR, MUNIT_ASSERTION_CLASS));
        }
        try {
            MunitAssertion munitAssertion = (MunitAssertion)Class.forName(assertion).newInstance();
            munitAssertion.execute(org.mule.munit.assertion.api.TypedValue.fromMuleTypedValue(expression), params);
        }
        catch (ClassCastException e) {
            throw new MunitError(String.format(RUN_CUSTOM_INTERFACE_ERROR, MUNIT_ASSERTION_CLASS));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MunitError(RUN_CUSTOM_ERROR, (Throwable)e);
        }
    }

    protected void setAssertModule(AssertModule assertModule) {
        this.assertModule = assertModule;
    }
}

