/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.tools.util.ReusableByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MunitResource {
    private static Logger logger = LoggerFactory.getLogger(MunitResource.class);
    private String path;
    private ClassLoader classLoader;

    public MunitResource(String path, ClassLoader classLoader) {
        this.path = path;
        this.classLoader = classLoader;
    }

    public InputStream asStream() {
        InputStream streamInput = this.classLoader.getResourceAsStream(this.path);
        if (streamInput == null) {
            throw new IllegalArgumentException("The path provided to get the resource does not exist");
        }
        return streamInput;
    }

    public String asString(Charset charset) {
        try {
            return IOUtils.toString((InputStream)this.asStream(), (Charset)charset);
        }
        catch (IOException ioe) {
            logger.error("The file is corrupted");
            return null;
        }
    }

    public byte[] asByteArray() {
        byte[] byteArrayInput = null;
        try {
            byteArrayInput = IOUtils.toByteArray((InputStream)this.asStream());
        }
        catch (IOException ioe) {
            logger.error("The file is corrupted");
        }
        return byteArrayInput;
    }

    public InputStream asReusableStream() {
        InputStream streamInput = this.asStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)streamInput, (OutputStream)outputStream);
        }
        catch (IOException e) {
            logger.error("The file is corrupted");
        }
        return new ReusableByteArrayInputStream(outputStream.toByteArray());
    }
}

