/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.assertion;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.mule.munit.assertion.api.MunitAssertion;
import org.mule.munit.assertion.api.expression.MatcherResult;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.internal.AssertModule;
import org.mule.munit.assertion.internal.HamcrestFactory;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.tools.assertion.AssertionErrorProvider;
import org.mule.munit.tools.assertion.InvalidAssertionExpressionException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;

public class AssertOperations {
    private static final String RUN_CUSTOM_INTERFACE_ERROR = "The run-custom operation requires a class implementing %s. Please provide one.";
    private static final String RUN_CUSTOM_ERROR = "Unable to create custom assertion";
    private static final String MUNIT_ASSERTION_CLASS = "org.mule.munit.assertion.api.MunitAssertion";
    private static final String DEFAULT_ASSERT_CONTENT = "#[import * from dw::test::Asserts \n ---\npayload must notBeNull()]";
    private static final String LOCATION_MESSAGE = " at file: [%s], line: [%d]";
    private static final String MUNIT_BINDING_NAME = "munit_equal_to_placeholder";
    private static final String EQUAL_TO_WRAPPER = "#[MunitTools::equalTo(munit_equal_to_placeholder)]";
    private AssertModule assertModule = new AssertModule();
    @Inject
    public ExpressionManager expressionManager;

    @Summary(value="Perform an assertion over an expression")
    public void assertThat(@Example(value="#[payload]") TypedValue<?> expression, @Expression(value=ExpressionSupport.REQUIRED) @Example(value="#[MunitTools::notNullValue()]") Matcher is, @Optional(defaultValue="") String message, ComponentLocation location) {
        this.assertModule.assertThat(message + this.locationMessage(location), expression, HamcrestFactory.create((Matcher)is));
    }

    @Summary(value="Asserts that an expression is successful")
    @DisplayName(value="Assert expression")
    @Alias(value="assert")
    @Throws(value={AssertionErrorProvider.class})
    public void assertExpression(@DisplayName(value="Expression") @Optional(defaultValue="#[import * from dw::test::Asserts \n ---\npayload must notBeNull()]") @Content ParameterResolver<MatcherResult> that, @Optional(defaultValue="Assertion failed") String message, ComponentLocation location) {
        try {
            this.assertModule.assertMatcherResult((MatcherResult)that.resolve(), message + this.locationMessage(location));
        }
        catch (ExpressionRuntimeException e) {
            if (e.getMessage().contains(String.format("to class '%s'", MatcherResult.class.getSimpleName()))) {
                throw new InvalidAssertionExpressionException(that.getExpression().orElse(""), e);
            }
            throw e;
        }
    }

    @Summary(value="Check if an expression is equal to a value")
    public void assertEquals(@Example(value="#[payload]") TypedValue<?> actual, @Example(value="#['EXAMPLE']") TypedValue<?> expected, @Optional(defaultValue="") String message, ComponentLocation location) {
        BindingContext bindingContext = BindingContext.builder().addBinding(MUNIT_BINDING_NAME, expected).build();
        Matcher equalToMatcher = (Matcher)this.expressionManager.evaluate(EQUAL_TO_WRAPPER, bindingContext).getValue();
        this.assertModule.assertThat(message + this.locationMessage(location), actual, HamcrestFactory.create((Matcher)equalToMatcher));
    }

    @Summary(value="Fail with an assertion")
    public void fail(@Optional(defaultValue="") String message) {
        Assert.fail((String)message);
    }

    @Summary(value="Run a custom assertion")
    public void runCustom(@Example(value="com.example.CustomAssertion") @ClassValue(extendsOrImplements={"org.mule.munit.assertion.api.MunitAssertion"}) String assertion, @Example(value="#[payload]") TypedValue<Object> expression, @Optional Object params) {
        if (StringUtils.isBlank((CharSequence)assertion)) {
            throw new MunitError(String.format(RUN_CUSTOM_INTERFACE_ERROR, MUNIT_ASSERTION_CLASS));
        }
        try {
            MunitAssertion munitAssertion = (MunitAssertion)Class.forName(assertion).newInstance();
            munitAssertion.execute(org.mule.munit.assertion.api.TypedValue.fromMuleTypedValue(expression), params);
        }
        catch (ClassCastException e) {
            throw new MunitError(String.format(RUN_CUSTOM_INTERFACE_ERROR, MUNIT_ASSERTION_CLASS));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MunitError(RUN_CUSTOM_ERROR, (Throwable)e);
        }
    }

    protected void setAssertModule(AssertModule assertModule) {
        this.assertModule = assertModule;
    }

    private String locationMessage(ComponentLocation location) {
        return String.format(LOCATION_MESSAGE, location.getFileName().orElse("UNKNOWN"), location.getLineInFile().orElse(-1));
    }
}

