/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.util.store;

import java.io.Serializable;
import javax.inject.Inject;
import org.mule.munit.runner.component.rules.TemporaryStorageRule;
import org.mule.munit.tools.MunitToolsErrorDefinition;
import org.mule.munit.tools.util.store.MissingKeyException;
import org.mule.munit.tools.util.store.StorageErrorProvider;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class StorageOperations {
    @Inject
    protected TemporaryStorageRule storageRule;

    @Summary(value="Stores the given data associated with the given key")
    @Throws(value={StorageErrorProvider.class})
    public void store(String key, @Optional(defaultValue="#[payload]") @Content TypedValue<Serializable> value) {
        this.validateKey(key);
        this.storageRule.store(key, value);
    }

    @Summary(value="Retrieves the data associated with the given key")
    @Throws(value={StorageErrorProvider.class})
    public Result<Serializable, Void> retrieve(String key) {
        this.validateKey(key);
        return this.asResult(this.storageRule.retrieve(key).orElseThrow(() -> new MissingKeyException(key)));
    }

    @Summary(value="Removes the data associated with the given key")
    @Throws(value={StorageErrorProvider.class})
    public Result<Serializable, Void> remove(String key) {
        this.validateKey(key);
        return this.asResult(this.storageRule.remove(key).orElseThrow(() -> new MissingKeyException(key)));
    }

    @Summary(value="Clears all stored data")
    public void clearStoredData() {
        this.storageRule.clear();
    }

    private Result<Serializable, Void> asResult(Object value) {
        TypedValue typedValue = value instanceof TypedValue ? (TypedValue)value : new TypedValue((Object)((Serializable)value), DataType.fromType(value.getClass()));
        return Result.builder().output(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType()).build();
    }

    private void validateKey(String key) {
        if (key == null || key.trim().length() == 0) {
            throw new ModuleException((ErrorTypeDefinition)MunitToolsErrorDefinition.INVALID_KEY, (Throwable)new IllegalArgumentException("Key cannot be null nor empty"));
        }
    }
}

