/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools;

import org.mule.munit.assertion.api.MunitAssertion;
import org.mule.munit.assertion.api.matchers.Diff;
import org.mule.munit.tools.assertion.AssertOperations;
import org.mule.munit.tools.mock.MockOperations;
import org.mule.munit.tools.util.GetResourceFunctions;
import org.mule.munit.tools.util.store.StorageOperations;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;

/**
 * <p>
 * MUnit Tools to perform testing on mule
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
@Extension(name = "MUnit Tools")
@Xml(prefix = "munit-tools")
@Export(classes = {MunitAssertion.class, Diff.class, GetResourceFunctions.class},
    resources = {"MunitTools.dwl", "dw/test/Asserts.dwl", "dw/test/internal/Utils.dwl"})
@Operations({AssertOperations.class, MockOperations.class, StorageOperations.class})
@ErrorTypes(MunitToolsErrorDefinition.class)
public class MunitTools {

}
