/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util.store;

import static com.google.common.collect.Sets.newHashSet;
import static org.mule.munit.tools.MunitToolsErrorDefinition.INVALID_KEY;
import static org.mule.munit.tools.MunitToolsErrorDefinition.MISSING_KEY;

import java.util.Set;

import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

/**
 * {@link ErrorTypeProvider} implementation for operations that throw an INVALID_ASSERTION Error
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class StorageErrorProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    return newHashSet(MISSING_KEY, INVALID_KEY);
  }
}
