/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.mock;

import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Variable;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

import java.io.Serializable;
import java.util.List;

/**
 * Utility functions to handle streaming
 * 
 * @since 2.1.4
 * @author Mulesoft Inc.
 */
public class StreamingUtils {

  public static void resolveCursorProviders(StreamingHelper streamingHelper, Event event) {
    if (event == null) {
      return;
    }
    resolvePayload(streamingHelper, event.getPayload());
    resolveAttributes(streamingHelper, event.getAttributes());
    resolveVariables(streamingHelper, event.getVariables());
  }

  private static void resolveVariables(StreamingHelper streamingHelper, List<Variable> variables) {
    if (variables == null) {
      return;
    }
    variables.forEach(variable -> variable.setValue((Serializable) resolveCursorProvider(streamingHelper, variable.getValue())));
  }

  private static void resolveAttributes(StreamingHelper streamingHelper, EventAttributes attributes) {
    if (attributes == null) {
      return;
    }
    attributes.setValue(resolveCursorProvider(streamingHelper, attributes.getValue()));
  }

  private static void resolvePayload(StreamingHelper streamingHelper, Payload payload) {
    if (payload == null) {
      return;
    }
    payload.setValue(resolveCursorProvider(streamingHelper, payload.getValue()));
  }

  private static Object resolveCursorProvider(StreamingHelper streamingHelper, Object value) {
    return streamingHelper.resolveCursorProvider(value);
  }

}
