/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import static org.apache.commons.lang3.StringUtils.isBlank;

import java.io.InputStream;
import java.nio.charset.Charset;

/**
 * Utility functions to handle resources
 * 
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class GetResourceFunctions {

  private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

  public static byte[] getResourceAsByteArray(String path) {
    return new MunitResource(path, classLoader).asByteArray();
  }

  public static String getResourceAsString(String path, String encoding) {
    return new MunitResource(path, classLoader)
        .asString(isBlank(encoding) ? Charset.defaultCharset() : Charset.forName(encoding));
  }

  public static InputStream getResourceAsStream(String path) {
    return new MunitResource(path, classLoader).asStream();
  }

  public static InputStream getResourceAsReusableStream(String path) {
    return new MunitResource(path, classLoader).asReusableStream();
  }

}
