/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import org.mule.runtime.extension.api.annotation.param.Optional;

import java.util.concurrent.TimeUnit;

/**
 * UtilsOperations
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class UtilsOperations {

  /**
   * Causes the currently executing thread to sleep
   *
   * @param time     The length of time to sleep
   * @param timeUnit Time Unit to use to sleep
   */
  public void sleep(Long time, @Optional(defaultValue = "MILLISECONDS") TimeUnit timeUnit) {
    try {
      timeUnit.sleep(time);
    } catch (InterruptedException e) {
      throw new SleepInterruptedException();
    }
  }
}
