/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.mock;

import java.util.List;
import org.mule.munit.common.api.model.Event;
import org.mule.munit.common.api.model.EventAttributes;
import org.mule.munit.common.api.model.Payload;
import org.mule.munit.common.api.model.Variable;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class StreamingUtils {
    public static void resolveCursorProviders(StreamingHelper streamingHelper, Event event) {
        if (event == null) {
            return;
        }
        StreamingUtils.resolvePayload(streamingHelper, event.getPayload());
        StreamingUtils.resolveAttributes(streamingHelper, event.getAttributes());
        StreamingUtils.resolveVariables(streamingHelper, event.getVariables());
    }

    private static void resolveVariables(StreamingHelper streamingHelper, List<Variable> variables) {
        if (variables == null) {
            return;
        }
        variables.forEach(variable -> variable.setValue(StreamingUtils.resolveCursorProvider(streamingHelper, variable.getValue())));
    }

    private static void resolveAttributes(StreamingHelper streamingHelper, EventAttributes attributes) {
        if (attributes == null) {
            return;
        }
        attributes.setValue(StreamingUtils.resolveCursorProvider(streamingHelper, attributes.getValue()));
    }

    private static void resolvePayload(StreamingHelper streamingHelper, Payload payload) {
        if (payload == null) {
            return;
        }
        payload.setValue(StreamingUtils.resolveCursorProvider(streamingHelper, payload.getValue()));
    }

    private static Object resolveCursorProvider(StreamingHelper streamingHelper, Object value) {
        return streamingHelper.resolveCursorProvider(value);
    }
}

