/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Test;

public class AssertEqualsTestCase extends AssertionTestCase {

  @Override
  protected String getConfigFile() {
    return "assertion/assert-equals.xml";
  }

  @Test
  public void equalToBoolean() throws Exception {
    runFlow("equalToBoolean");
  }

  @Test
  public void equalToInteger() throws Exception {
    runFlow("equalToInteger");
  }

  @Test
  public void equalToString() throws Exception {
    runFlow("equalToString");
  }

  @Test
  public void equalToPayload() throws Exception {
    runFlow("equalToPayload");
  }

  @Test
  public void equalToVariable() throws Exception {
    runFlow("equalToVariable");
  }

  @Test
  public void equalToStructure() throws Exception {
    runFlow("equalToStructure");
  }

  @Test
  public void equalToStructureFromFile() throws Exception {
    runFlow("equalToStructureFromFile");
  }

  @Test
  public void equalToFail() throws Exception {
    runExpectingAssertionError("equalToFail");
  }

  @Test
  public void equalToWithLiteralExpected() throws Exception {
    runFlow("equalToWithLiteralExpected");
  }

}
