/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Test;

public class FailAndCustomAssertionTestCase extends AssertionTestCase {

  @Override
  protected String getConfigFile() {
    return "assertion/fail-and-custom-assertion.xml";
  }

  @Test
  public void failWithMessage() throws Exception {
    runExpectingAssertionError("failWithMessage", "EXAMPLE MESSAGE");
  }

  @Test
  public void failWithoutMessage() throws Exception {
    runExpectingAssertionError("failWithoutMessage");
  }

  @Test
  public void customStartsWithAssertion() throws Exception {
    runFlow("customStartsWithAssertion");
  }

  @Test
  public void customStartsWithAssertionFail() throws Exception {
    runExpectingAssertionError("customStartsWithAssertionFail");
  }

}
