/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Test;

public class AssertionStringMatchersTestCase extends AssertionTestCase {

  @Override
  protected String getConfigFile() {
    return "assertion/string-matchers.xml";
  }

  @Test
  public void matchesRegex() throws Exception {
    runFlow("matchesRegex");
    runFlow("jsonMatchesRegex");
  }

  @Test
  public void dontMatchRegex() throws Exception {
    runExpectingAssertionError("dontMatchRegex", "Expected: A string matching EX.*");
    runExpectingAssertionError("jsonDontMatchRegex", "Expected: A string matching rge.*");
  }

  @Test
  public void containsString() throws Exception {
    runFlow("containsString");
    runFlow("jsonContainsString");
  }

  @Test
  public void containsStringFail() throws Exception {
    runExpectingAssertionError("containsStringFail", "Expected: A string containing PLES");
    runExpectingAssertionError("jsonContainsStringFail", "Expected: A string containing jo");
  }

  @Test
  public void startsWith() throws Exception {
    runFlow("startsWith");
    runFlow("jsonStartsWith");
  }

  @Test
  public void startsWithFail() throws Exception {
    runExpectingAssertionError("startsWithFail", "Expected: A string starting with XA");
    runExpectingAssertionError("jsonStartsWithFail", "Expected: A string starting with N");
  }

  @Test
  public void endsWith() throws Exception {
    runFlow("endsWith");
    runFlow("jsonEndsWith");
  }

  @Test
  public void endsWithFail() throws Exception {
    runExpectingAssertionError("endsWithFail", "Expected: A string ending with PLES");
    runExpectingAssertionError("jsonEndsWithFail", "Expected: A string ending with rl");
  }

  @Test
  public void isEmptyString() throws Exception {
    runFlow("isEmptyString");
    runFlow("jsonIsEmptyString");
  }

  @Test
  public void isEmptyStringFail() throws Exception {
    runExpectingAssertionError("isEmptyStringFail", "Expected: An empty string");
    runExpectingAssertionError("jsonIsEmptyStringFail", "Expected: An empty string");
  }

  @Test
  public void isEmptyOrNullString() throws Exception {
    runFlow("isEmptyOrNullString");
    runFlow("jsonIsEmptyOrNullString");
  }

  @Test
  public void isEmptyOrNullStringFail() throws Exception {
    runExpectingAssertionError("isEmptyOrNullStringFail", "Expected: An empty or null string");
    runExpectingAssertionError("jsonIsEmptyOrNullStringFail", "Expected: An empty or null string");
  }

  @Test
  public void equalToIgnoringCase() throws Exception {
    runFlow("equalToIgnoringCase");
    runFlow("jsonEqualToIgnoringCase");
  }

  @Test
  public void equalToIgnoringCaseFail() throws Exception {
    runExpectingAssertionError("equalToIgnoringCaseFail", "Expected: 'examples' ignoring case");
    runExpectingAssertionError("jsonEqualToIgnoringCaseFail", "Expected: 'carl' ignoring case");
  }

  @Test
  public void equalToIgnoringWhiteSpace() throws Exception {
    runFlow("equalToIgnoringWhiteSpace");
    runFlow("jsonEqualToIgnoringWhiteSpace");
  }

  @Test
  public void equalToIgnoringWhiteSpaceFail() throws Exception {
    runExpectingAssertionError("equalToIgnoringWhiteSpaceFail", "Expected: THISISANEXAMPLE");
    runExpectingAssertionError("jsonEqualToIgnoringWhiteSpaceFail", "Expected: THISISANEXAMPLE");
  }

  @Test
  public void stringContainsInOrder() throws Exception {
    runFlow("stringContainsInOrder");
    runFlow("jsonStringContainsInOrder");
  }

  @Test
  public void stringContainsInOrderFail() throws Exception {
    runExpectingAssertionError("stringContainsInOrderFail", "Expected: EXAMPLE, THIS, in order");
    runExpectingAssertionError("jsonStringContainsInOrderFail", "Expected: EXAMPLE, THIS, in order");
  }

}
