/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;


public abstract class AssertionTestCase extends MunitToolsTestCase {

  public void runExpectingAssertionError(String flowName) throws Exception {
    runExpectingAssertionError(flowName, null);
  }

  public void runExpectingAssertionError(String flowName, String message) throws Exception {
    Exception exception = flowRunner(flowName).runExpectingException();
    assertThat(exception.getCause() instanceof AssertionError, equalTo(true));
    if (message != null) {
      assertThat(exception.getCause().getMessage(), containsString(message));
    }
  }

}
