/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import static java.nio.charset.StandardCharsets.UTF_8;
import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;
import org.junit.Test;

public class MunitResourceTest {

  @Test(expected = IllegalArgumentException.class)
  public void testMunitResourceAsStreamNotFound() throws IOException {
    String path = "testFile.txtx";
    MunitResource file = createResource(path);
    InputStream is = file.asStream();
  }

  @Test
  public void testMunitResourceAsStream() throws IOException {
    String path = "util/files/testFile.txt";
    MunitResource file = createResource(path);

    InputStream is = file.asStream();
    assertEquals("Hello World!", IOUtils.toString(is, UTF_8.name()));
  }

  @Test
  public void testMunitResourceAsString() {
    String path = "util/files/testFile.txt";
    MunitResource file = createResource(path);
    String result = file.asString(Charset.defaultCharset());
    assertEquals("Hello World!", result);
  }

  @Test(expected = IllegalArgumentException.class)
  public void testCaseWhenFileDoesNotExist() {
    createResource("anything").asStream();
  }

  @Test
  public void testMunitResourceAsByteArray() throws IOException {
    String path = "util/files/testFile.txt";
    MunitResource file = createResource(path);
    byte[] result = file.asByteArray();
    assertEquals("Hello World!", new String(result));
  }

  @Test
  public void testMunitResourceAsReusableStream() throws IOException {
    String path = "util/files/testFile.txt";
    MunitResource file = createResource(path);

    InputStream is = file.asReusableStream();

    assertEquals("Hello World!", IOUtils.toString(is, UTF_8.name()));
    assertEquals("Hello World!", IOUtils.toString(is, UTF_8.name()));
    assertEquals("Hello World!", IOUtils.toString(is, UTF_8.name()));
  }

  private MunitResource createResource(String path) {
    return new MunitResource(path, this.getClass().getClassLoader());
  }

}
