/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import static java.nio.charset.StandardCharsets.UTF_8;

import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

import java.io.IOException;

public class ReusableByteArrayInputStreamTest {

  @Test
  public void testConsumption() throws IOException {
    String value = "abcd";
    ReusableByteArrayInputStream is = new ReusableByteArrayInputStream(value.getBytes());

    Assert.assertEquals("abcd", IOUtils.toString(is, UTF_8.name()));
    Assert.assertEquals("The consumed input stream should have been resetted", "abcd", IOUtils.toString(is, UTF_8.name()));
  }

  @Test
  public void testClosing() throws IOException {
    byte[] bytes = new byte[1];
    String value = "abcd";
    ReusableByteArrayInputStream is = new ReusableByteArrayInputStream(value.getBytes());

    is.read(bytes, 0, 1);
    is.close();
    Assert.assertEquals("The closed input stream should have been resetted", "abcd", IOUtils.toString(is, UTF_8.name()));

  }

}
