/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util.queue.internal.error;

import static org.mule.munit.tools.MunitToolsErrorDefinition.QUEUE_TIMEOUT;

import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * Exception thrown when an {@link InterruptedException} is thrown when performing operations over a queue
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class QueueTimeOutException extends ModuleException {


  public QueueTimeOutException() {
    super("Time out waiting for queue to return a result", QUEUE_TIMEOUT);
  }

  public QueueTimeOutException(String queueName) {
    super("Time out waiting for the queue \"" + queueName + "\" to return a result", QUEUE_TIMEOUT);
  }

  public QueueTimeOutException(Throwable cause, String queueName) {
    super("An error occurred while waiting for the queue \"" + queueName + "\" to return a result", QUEUE_TIMEOUT, cause);
  }
}
