/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;

import static org.hamcrest.core.Is.is;

public class AssertionExpressionTestCase extends AssertionTestCase {

  @Rule
  public ExpectedError expectedError = ExpectedError.none();

  @Override
  protected String getConfigFile() {
    return "assertion/assert-expression.xml";
  }

  private StringBuilder messageBuilder;

  @Before
  public void setUp() {
    messageBuilder = new StringBuilder();
  }

  @Test
  public void assertExpression() throws Exception {
    runFlow("assertExpression");
  }

  @Test
  public void assertPayloadExpression() throws Exception {
    runFlow("assertPayloadExpression");
  }

  @Test
  public void assertExpressionFailureWithMessage() throws Exception {
    messageBuilder
        .append("The payload should be a number at file: [assertion/assert-expression.xml], line: [32]")
        .append(System.lineSeparator())
        .append("Expected: Number type").append(System.lineSeparator())
        .append("Actual: String");
    runExpectingAssertionError("assertExpressionFailureWithMessage", messageBuilder.toString());
  }

  @Test
  public void assertExpressionFailure() throws Exception {
    messageBuilder
        .append("Assertion failed at file: [assertion/assert-expression.xml], line: [42]").append(System.lineSeparator())
        .append("Expected: Number type").append(System.lineSeparator())
        .append("Actual: String");
    runExpectingAssertionError("assertExpressionFailure", messageBuilder.toString());
  }

  @Test
  public void assertExpressionFailureWithReasons() throws Exception {
    messageBuilder
        .append("Assertion failed at file: [assertion/assert-expression.xml], line: [52]").append(System.lineSeparator())
        .append("Expected: {\n  title: \"Sr\",\n  name: \"Popo\"\n} to be equal to").append(System.lineSeparator())
        .append("Actual: {\n  title: \"Mr\",\n  name: \"Popo\"\n}").append(System.lineSeparator())
        .append("Reasons: Expecting `(root).title` to be \"Sr\" but was \"Mr\"");
    runExpectingAssertionError("assertExpressionFailureWithReasons", messageBuilder.toString());
  }

  @Test
  public void invalidAssertion() throws Exception {
    expectedError.expectErrorType("MUNIT-TOOLS", "INVALID_ASSERTION");
    expectedError.expectMessage(is("Expression is not a valid assertion: #[2]"));
    runFlow("invalidAssertion");
  }

  @Test
  public void invalidExpression() throws Exception {
    expectedError.expectErrorType("MULE", "EXPRESSION");
    runFlow("invalidExpression");
  }
}
