/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package assertion;


import org.junit.Before;
import org.junit.Test;
import org.mule.munit.tools.MunitToolsErrorDefinition;
import org.mule.munit.tools.assertion.AssertionErrorProvider;

import java.util.Set;

import static org.junit.Assert.*;

public class AssertionErrorProviderTest {

  private AssertionErrorProvider assertionErrorProvider;

  @Before
  public void setUp() {
    assertionErrorProvider = new AssertionErrorProvider();
  }

  @Test
  public void testGetErrorTypes_ReturnsCorrectErrorType() {
    Set<?> errorTypes = assertionErrorProvider.getErrorTypes();

    assertNotNull(errorTypes);
    assertEquals(1, errorTypes.size());

    // Ensure the set contains the expected error definition
    assertTrue(errorTypes.contains(MunitToolsErrorDefinition.INVALID_ASSERTION));
  }
}
