/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import static java.nio.charset.StandardCharsets.ISO_8859_1;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import org.apache.commons.io.IOUtils;
import org.junit.Test;

import org.mule.munit.tools.assertion.MunitToolsTestCase;
import org.mule.runtime.api.event.Event;

public class GetResourceTestCase extends MunitToolsTestCase {

  private static final String FILE_CONTENT = "EXAMPLE_PAYLOAD" + System.lineSeparator();

  @Override
  protected String getConfigFile() {
    return "util/get-resource-functions.xml";
  }

  @Test
  public void asString() throws Exception {
    Event result = runFlow("getResourceAsString");
    assertThat(result.getMessage().getPayload().getValue(), equalTo(FILE_CONTENT));
  }

  @Test
  public void asStringWithEncoding() throws Exception {
    String encodedString = IOUtils.toString(getClass().getClassLoader().getResource("util/files/exampleISO.txt"), ISO_8859_1);
    Event result = runFlow("getResourceAsStringWithEncoding");

    assertThat(result.getMessage().getPayload().getValue(), equalTo(encodedString));
  }

  @Test
  public void asByteArray() throws Exception {
    Event result = runFlow("getResourceAsByteArray");
    ByteArrayInputStream value = (ByteArrayInputStream) result.getMessage().getPayload().getValue();
    assertThat(IOUtils.toString(value, Charset.defaultCharset().name()), equalTo(FILE_CONTENT));
  }

  @Test
  public void asStream() throws Exception {
    Event result = runFlow("getResourceAsStream");
    InputStream value = (InputStream) result.getMessage().getPayload().getValue();
    assertThat(IOUtils.toString(value, Charset.defaultCharset().name()), equalTo(FILE_CONTENT));
  }

  @Test
  public void asReusableStream() throws Exception {
    Event result = runFlow("getResourceAsReusableStream");
    InputStream value = (InputStream) result.getMessage().getPayload().getValue();
    assertThat(IOUtils.toString(value, Charset.defaultCharset().name()), equalTo(FILE_CONTENT));
    assertThat(IOUtils.toString(value, Charset.defaultCharset().name()), equalTo(FILE_CONTENT));
  }

}
