/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util.queue.api;

import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.mule.munit.tools.util.queue.api.TemporaryQueueRule.DEFAULT_QUEUE_NAME;

import java.io.Serializable;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.munit.tools.util.queue.internal.error.QueueTimeOutException;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;

//TODO ARREGLAR TESTS
@Ignore
public class TemporaryQueueRuleTest {

  private static final Serializable CONTENT = "Example";
  private TemporaryQueueRule temporaryQueueRule;
  private Queue queueMock;

  @Before
  public void setUp() {
    QueueManager queueManagerMock = mock(QueueManager.class);
    QueueSession sessionMock = mock(QueueSession.class);

    temporaryQueueRule = new TemporaryQueueRule();
    temporaryQueueRule.queueManager = queueManagerMock;
    queueMock = mock(Queue.class);

    when(queueManagerMock.getQueueSession()).thenReturn(sessionMock);
    when(sessionMock.getQueue(DEFAULT_QUEUE_NAME)).thenReturn(queueMock);
    temporaryQueueRule.initialise();
  }

  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Test
  public void push() throws Exception {
    temporaryQueueRule.push(CONTENT, DEFAULT_QUEUE_NAME);

    verify(queueMock).put(CONTENT);
  }

  @Test
  public void popWithoutTimeOut() throws Exception {
    temporaryQueueRule.pop(DEFAULT_QUEUE_NAME, null);

    verify(queueMock).take();
  }

  @Test
  public void popWithTimeOut() throws Exception {
    temporaryQueueRule.pop(DEFAULT_QUEUE_NAME, 1L);

    verify(queueMock).poll(1L);
  }

  @Test
  public void queueException() throws Exception {
    String expectedErrorMessage =
        "An error occurred while waiting for the queue \"" + DEFAULT_QUEUE_NAME + "\" to return a result";
    doThrow(new InterruptedException()).when(queueMock).take();

    expectedException.expect(QueueTimeOutException.class);
    expectedException.expectMessage(expectedErrorMessage);

    temporaryQueueRule.pop(DEFAULT_QUEUE_NAME, null);
  }

  @Test
  public void size() {
    TemporaryQueueRule.size(DEFAULT_QUEUE_NAME);

    verify(queueMock).size();
  }

}
