/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package util;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;
import org.mule.munit.tools.util.ReusableByteArrayInputStream;

import java.io.IOException;

public class ReusableByteArrayInputStreamTest {

  private ReusableByteArrayInputStream stream;
  private byte[] testData;

  @Before
  public void setUp() {
    testData = new byte[] {1, 2, 3, 4, 5};
    stream = new ReusableByteArrayInputStream(testData);
  }

  @Test
  public void testReadSingleByte() {
    assertEquals(1, stream.read());
    assertEquals(2, stream.read());
  }

  @Test
  public void testReadByteArray() {
    byte[] buffer = new byte[3];
    int bytesRead = stream.read(buffer, 0, 3);
    assertEquals(3, bytesRead);
    assertArrayEquals(new byte[] {1, 2, 3}, buffer);
  }

  @Test
  public void testEndOfStreamResets() {
    byte[] buffer = new byte[5];
    stream.read(buffer, 0, 5);
    assertEquals(-1, stream.read());
  }

  @Test
  public void testCloseResetsStream() throws IOException {
    byte[] buffer = new byte[5];
    stream.read(buffer, 0, 5);
    stream.close();
    assertEquals(1, stream.read());
  }

  @Test
  public void testReadWithOffsetAndLength() {
    ReusableByteArrayInputStream stream2 = new ReusableByteArrayInputStream(testData, 2, 2);
    assertEquals(3, stream2.read());
    assertEquals(4, stream2.read());
    assertEquals(-1, stream2.read());
  }

  @Test
  public void testMarkAndResetFunctionality() {
    stream.read();
    stream.mark(0);
    assertEquals(2, stream.read());
    assertEquals(3, stream.read());
    stream.reset();
    assertEquals(2, stream.read());
  }
}
