/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import static java.lang.String.format;

import org.mule.munit.tools.MunitToolsErrorDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * {@link ModuleException} when expression inside the assert is invalid
 * 
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class InvalidAssertionExpressionException extends ModuleException {

  public InvalidAssertionExpressionException(String invalidExpression, Throwable cause) {
    super(format("Expression is not a valid assertion: %s", invalidExpression), MunitToolsErrorDefinition.INVALID_ASSERTION,
          new RuntimeException(cause.getMessage()));
  }

  public InvalidAssertionExpressionException(String invalidExpression) {
    super(format("Expression is not a valid assertion: %s", invalidExpression), MunitToolsErrorDefinition.INVALID_ASSERTION);
  }
}
