/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util.queue;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasKey;

import org.mule.functional.api.exception.ExpectedError;
import org.mule.munit.tools.assertion.MunitToolsTestCase;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;

import java.util.Map;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;

public class QueueTestCase extends MunitToolsTestCase {

  @Rule
  public ExpectedError expectedError = ExpectedError.none();

  @Override
  protected String getConfigFile() {
    return "util/queue-operations.xml";
  }

  @Test
  public void queueAndDequeue() throws Exception {
    CoreEvent event = runFlow("queueAndDequeue");
    assertThat(event.getMessage().getPayload().getValue(), equalTo(1));
  }

  @Test
  public void queuePayload() throws Exception {
    CoreEvent event = runFlow("queuePayload");
    assertThat(event.getMessage().getPayload().getValue(), equalTo("EXAMPLE"));
  }

  @Test
  public void dequeueTimeOut() throws Exception {
    expectedError.expectErrorType("MUNIT-TOOLS", "QUEUE_TIMEOUT");
    expectedError.expectCause(getExceptionMessageMatcher("Time out waiting for queue to return a result"));
    runFlow("dequeueTimeOut");
  }

  @Test
  public void namedQueueDequeueTimeOut() throws Exception {
    expectedError.expectErrorType("MUNIT-TOOLS", "QUEUE_TIMEOUT");
    expectedError.expectCause(getExceptionMessageMatcher("Time out waiting for the queue \"timeoutQueue\" to return a result"));
    runFlow("namedQueueDequeueTimeOut");
  }

  @Test
  public void multipleQueues() throws Exception {
    CoreEvent event = runFlow("multipleQueues");
    Map<String, TypedValue<?>> variables = event.getVariables();

    assertThat(variables, hasKey("first"));
    assertThat(variables, hasKey("second"));
    assertThat(variables, hasKey("third"));
    assertThat(variables.get("first").getValue(), equalTo("First"));
    assertThat(variables.get("second").getValue(), equalTo("Second"));
    assertThat(variables.get("third").getValue(), equalTo("Third"));
  }

  private Matcher<Throwable> getExceptionMessageMatcher(String message) {
    return new BaseMatcher<Throwable>() {

      @Override
      public boolean matches(Object o) {
        if (!(o instanceof Exception)) {
          return false;
        }
        return ((Exception) o).getMessage().equals(message);
      }

      @Override
      public void describeTo(Description description) {}
    };
  }

}
