/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package util;

import org.junit.Test;
import org.mule.munit.tools.util.UtilsOperations;
import org.mule.munit.tools.util.SleepInterruptedException;
import java.util.concurrent.TimeUnit;
import static org.junit.Assert.*;

public class UtilsOperationsTest {

  @Test
  public void testSleepWithValidTimeUnit() {
    UtilsOperations utilsOperations = new UtilsOperations();
    long sleepTime = 100L;

    long startTime = System.currentTimeMillis();
    utilsOperations.sleep(sleepTime, TimeUnit.MILLISECONDS);
    long elapsedTime = System.currentTimeMillis() - startTime;

    assertTrue("Sleep time should be approximately the given time", elapsedTime >= sleepTime);
  }

  @Test
  public void testSleepWithInterruptedException() {
    UtilsOperations utilsOperations = new UtilsOperations();
    Thread testThread = new Thread(() -> {
      try {
        utilsOperations.sleep(5000L, TimeUnit.MILLISECONDS); // Sleep for long enough to be interrupted
        fail("Expected SleepInterruptedException to be thrown");
      } catch (SleepInterruptedException e) {
        assertNotNull("Exception should not be null", e);
      }
    });

    testThread.start();
    try {
      Thread.sleep(100); // Ensure sleep starts before interrupting
      testThread.interrupt(); // Interrupt the thread
      testThread.join(); // Wait for the thread to finish execution
    } catch (InterruptedException e) {
      fail("Test thread was unexpectedly interrupted");
    }
  }
}
