/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage;

import com.google.gson.Gson;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.munit.common.extensions.MunitPlugin;


public class CoberturaPlugin implements MunitPlugin, MuleContextAware {

    public static final String PORT = System.getProperty("cobertura.port", null);

    private MuleContext context;
    private CoberturaModule coberturaModule;

    @Override
    public void dispose() {
    }

    @Override
    public void initialise() throws InitialisationException {
        if (PORT != null) {
            this.coberturaModule = new CoberturaModule(context);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    @Override
    public void start() throws MuleException {
    }

    @Override
    public void stop() throws MuleException {
        Report report = coberturaModule.getReporter().getReport();
        if (PORT != null) {
            Gson gson = new Gson();
            String json = gson.toJson(report);
            new RemoteReporter().run(Integer.valueOf(PORT), json);
        }
    }
}
