/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage;

import java.util.*;

public class Reporter {

    private Set<String> subFlowPaths = new HashSet();
    private Set<String> flowPaths = new HashSet<String>();

    private Set<String> covered = new HashSet<String>();

    public void addCoveredPath(String path) {
        // Normal Path of any flow
        if (flowPaths.contains(path)) {
            covered.add(path);
            return;
        }

        // Flow ref to sub flows in a flow
        for (String p : flowPaths) {
            if (path.startsWith(p)) {
                // We save this path only as it represents the flow ref
                // The path will represent a sub-flow MP itself
                covered.add(p);
                //  we do not return the method
                // for this flags the flow ref as covered
                // but we still need to process the sub flow path
            }
        }

        // Sub flow paths
        for (String p : subFlowPaths) {
            if (path.contains(p)) {
                // We save p for this represents the unique sub-flow mp
                // independently from the flow/sub-flow who referenced it
                covered.add(p);
                break;
            }
        }
    }

    public void addFlowPaths(Collection<String> mps) {
        flowPaths.addAll(mps);
    }

    public void addSubFlowPaths(Collection<String> mps) {
        subFlowPaths.addAll(mps);
    }

    public Report getReport() {
        Map<String, Count> pathPerFlow = new HashMap<String, Count>();

        for (String path : flowPaths) {
            countPath(path, pathPerFlow, "/processors");
        }

        for (String path : subFlowPaths) {
            countPath(path, pathPerFlow, "/subprocessors");
        }

        double coverage = percentage(covered.size(), flowPaths.size() + subFlowPaths.size());

        Map<String, Double> containersCoverage = new HashMap<String, Double>();
        for (Map.Entry<String, Count> count : pathPerFlow.entrySet()) {
            containersCoverage.put(count.getKey(), percentage(count.getValue().coveredMp, count.getValue().totalMp));
        }

        return new Report(coverage, containersCoverage, covered, flowPaths);
    }

    private void countPath(String path, Map<String, Count> pathPerFlow, String tokenFlag) {
        String containerName = path.substring(0, path.indexOf(tokenFlag));
        if (!pathPerFlow.containsKey(containerName)) {
            pathPerFlow.put(containerName, new Count());
        }
        Count count = pathPerFlow.get(containerName);
        count.totalMp++;
        if (covered.contains(path)) {
            count.coveredMp++;
        }
    }

    private double percentage(int size, int size1) {
        if (size1 != 0) {

            return ((double) size / size1) * 100;
        }
        return 0;
    }

    private class Count {
        int totalMp;
        int coveredMp;
    }
}
